Ext.data.JsonP.sol_common_RepoUtils({"tagname":"class","name":"sol.common.RepoUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.RepoUtils.js","href":"lib_sol.common.RepoUtils.html#sol-common-RepoUtils"}],"author":[{"tagname":"author","name":"ELO Digital Office GmbH","email":null}],"eloas":true,"eloix":true,"requires":["sol.common.AsyncUtils","sol.common.FileUtils","sol.common.SordTypeUtils","sol.common.SordUtils","sol.common.StringUtils","sol.common.Template"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"bom","tagname":"property","owner":"sol.common.RepoUtils","id":"property-bom","meta":{"private":true}},{"name":"contentTypeExtensions","tagname":"property","owner":"sol.common.RepoUtils","id":"property-contentTypeExtensions","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"pilcrow","tagname":"property","owner":"sol.common.RepoUtils","id":"property-pilcrow","meta":{"private":true}},{"name":"replacementChar","tagname":"property","owner":"sol.common.RepoUtils","id":"property-replacementChar","meta":{"private":true}},{"name":"specialFolders","tagname":"property","owner":"sol.common.RepoUtils","id":"property-specialFolders","meta":{}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"addColors","tagname":"method","owner":"sol.common.RepoUtils","id":"method-addColors","meta":{}},{"name":"buildOrValuesSearchString","tagname":"method","owner":"sol.common.RepoUtils","id":"method-buildOrValuesSearchString","meta":{}},{"name":"calcNextVersion","tagname":"method","owner":"sol.common.RepoUtils","id":"method-calcNextVersion","meta":{}},{"name":"changePathSeparator","tagname":"method","owner":"sol.common.RepoUtils","id":"method-changePathSeparator","meta":{}},{"name":"checkRepoPath","tagname":"method","owner":"sol.common.RepoUtils","id":"method-checkRepoPath","meta":{"private":true}},{"name":"checkVersion","tagname":"method","owner":"sol.common.RepoUtils","id":"method-checkVersion","meta":{}},{"name":"checkVersions","tagname":"method","owner":"sol.common.RepoUtils","id":"method-checkVersions","meta":{}},{"name":"colorExists","tagname":"method","owner":"sol.common.RepoUtils","id":"method-colorExists","meta":{}},{"name":"copySords","tagname":"method","owner":"sol.common.RepoUtils","id":"method-copySords","meta":{}},{"name":"createConnFact","tagname":"method","owner":"sol.common.RepoUtils","id":"method-createConnFact","meta":{}},{"name":"createExternalLink","tagname":"method","owner":"sol.common.RepoUtils","id":"method-createExternalLink","meta":{}},{"name":"createObjKey","tagname":"method","owner":"sol.common.RepoUtils","id":"method-createObjKey","meta":{"private":true}},{"name":"createPath","tagname":"method","owner":"sol.common.RepoUtils","id":"method-createPath","meta":{}},{"name":"createTempFileWithSordName","tagname":"method","owner":"sol.common.RepoUtils","id":"method-createTempFileWithSordName","meta":{}},{"name":"deleteAllReferences","tagname":"method","owner":"sol.common.RepoUtils","id":"method-deleteAllReferences","meta":{}},{"name":"deleteSord","tagname":"method","owner":"sol.common.RepoUtils","id":"method-deleteSord","meta":{}},{"name":"detectScriptEnvironment","tagname":"method","owner":"sol.common.RepoUtils","id":"method-detectScriptEnvironment","meta":{}},{"name":"determinateSpecialFolders","tagname":"method","owner":"sol.common.RepoUtils","id":"method-determinateSpecialFolders","meta":{"private":true}},{"name":"downloadSmallContentToString","tagname":"method","owner":"sol.common.RepoUtils","id":"method-downloadSmallContentToString","meta":{}},{"name":"downloadToBase64String","tagname":"method","owner":"sol.common.RepoUtils","id":"method-downloadToBase64String","meta":{}},{"name":"downloadToByteArray","tagname":"method","owner":"sol.common.RepoUtils","id":"method-downloadToByteArray","meta":{}},{"name":"downloadToFile","tagname":"method","owner":"sol.common.RepoUtils","id":"method-downloadToFile","meta":{}},{"name":"downloadToFileData","tagname":"method","owner":"sol.common.RepoUtils","id":"method-downloadToFileData","meta":{"private":true}},{"name":"downloadToStream","tagname":"method","owner":"sol.common.RepoUtils","id":"method-downloadToStream","meta":{"private":true}},{"name":"downloadToString","tagname":"method","owner":"sol.common.RepoUtils","id":"method-downloadToString","meta":{}},{"name":"exists","tagname":"method","owner":"sol.common.RepoUtils","id":"method-exists","meta":{}},{"name":"exportRepoData","tagname":"method","owner":"sol.common.RepoUtils","id":"method-exportRepoData","meta":{}},{"name":"findChildren","tagname":"method","owner":"sol.common.RepoUtils","id":"method-findChildren","meta":{}},{"name":"findIds","tagname":"method","owner":"sol.common.RepoUtils","id":"method-findIds","meta":{}},{"name":"findInHierarchy","tagname":"method","owner":"sol.common.RepoUtils","id":"method-findInHierarchy","meta":{}},{"name":"findObjectTypeInHierarchy","tagname":"method","owner":"sol.common.RepoUtils","id":"method-findObjectTypeInHierarchy","meta":{}},{"name":"findSords","tagname":"method","owner":"sol.common.RepoUtils","id":"method-findSords","meta":{}},{"name":"getColorId","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getColorId","meta":{}},{"name":"getDownloadUrl","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getDownloadUrl","meta":{"private":true}},{"name":"getFirstChild","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getFirstChild","meta":{}},{"name":"getGuid","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getGuid","meta":{}},{"name":"getIxId","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getIxId","meta":{}},{"name":"getIxOption","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getIxOption","meta":{}},{"name":"getIxOptions","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getIxOptions","meta":{}},{"name":"getNameFromPath","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getNameFromPath","meta":{}},{"name":"getObjId","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getObjId","meta":{}},{"name":"getObjIdByIndex","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getObjIdByIndex","meta":{}},{"name":"getObjIdFromRelativePath","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getObjIdFromRelativePath","meta":{}},{"name":"getObjIdFromRelativeSolutionPath","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getObjIdFromRelativeSolutionPath","meta":{}},{"name":"getParentPath","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getParentPath","meta":{}},{"name":"getPath","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getPath","meta":{}},{"name":"getPathFromObjId","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getPathFromObjId","meta":{}},{"name":"getPathSeparator","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getPathSeparator","meta":{}},{"name":"getRepoPathObjIds","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getRepoPathObjIds","meta":{}},{"name":"getSessionOptions","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getSessionOptions","meta":{}},{"name":"getSord","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getSord","meta":{}},{"name":"getSords","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getSords","meta":{}},{"name":"getValidParent","tagname":"method","owner":"sol.common.RepoUtils","id":"method-getValidParent","meta":{}},{"name":"importRepoData","tagname":"method","owner":"sol.common.RepoUtils","id":"method-importRepoData","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"isArcpath","tagname":"method","owner":"sol.common.RepoUtils","id":"method-isArcpath","meta":{}},{"name":"isGuid","tagname":"method","owner":"sol.common.RepoUtils","id":"method-isGuid","meta":{}},{"name":"isLMatchPath","tagname":"method","owner":"sol.common.RepoUtils","id":"method-isLMatchPath","meta":{"private":true}},{"name":"isMd5HashPath","tagname":"method","owner":"sol.common.RepoUtils","id":"method-isMd5HashPath","meta":{}},{"name":"isObjId","tagname":"method","owner":"sol.common.RepoUtils","id":"method-isObjId","meta":{}},{"name":"isOkeyPath","tagname":"method","owner":"sol.common.RepoUtils","id":"method-isOkeyPath","meta":{}},{"name":"isRepoId","tagname":"method","owner":"sol.common.RepoUtils","id":"method-isRepoId","meta":{}},{"name":"moveSords","tagname":"method","owner":"sol.common.RepoUtils","id":"method-moveSords","meta":{}},{"name":"moveToStoragePath","tagname":"method","owner":"sol.common.RepoUtils","id":"method-moveToStoragePath","meta":{}},{"name":"normalizePath","tagname":"method","owner":"sol.common.RepoUtils","id":"method-normalizePath","meta":{}},{"name":"preparePath","tagname":"method","owner":"sol.common.RepoUtils","id":"method-preparePath","meta":{}},{"name":"readColors","tagname":"method","owner":"sol.common.RepoUtils","id":"method-readColors","meta":{}},{"name":"resolveSpecialFolder","tagname":"method","owner":"sol.common.RepoUtils","id":"method-resolveSpecialFolder","meta":{}},{"name":"saveToRepo","tagname":"method","owner":"sol.common.RepoUtils","id":"method-saveToRepo","meta":{}},{"name":"setSessionOption","tagname":"method","owner":"sol.common.RepoUtils","id":"method-setSessionOption","meta":{}},{"name":"setSessionOptions","tagname":"method","owner":"sol.common.RepoUtils","id":"method-setSessionOptions","meta":{}},{"name":"sortSordsByObjIdArray","tagname":"method","owner":"sol.common.RepoUtils","id":"method-sortSordsByObjIdArray","meta":{}},{"name":"uploadSmallContent","tagname":"method","owner":"sol.common.RepoUtils","id":"method-uploadSmallContent","meta":{}},{"name":"writeColors","tagname":"method","owner":"sol.common.RepoUtils","id":"method-writeColors","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.RepoUtils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.RepoUtils</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.AsyncUtils' rel='sol.common.AsyncUtils' class='docClass'>sol.common.AsyncUtils</a></div><div class='dependency'><a href='#!/api/sol.common.FileUtils' rel='sol.common.FileUtils' class='docClass'>sol.common.FileUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordTypeUtils' rel='sol.common.SordTypeUtils' class='docClass'>sol.common.SordTypeUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.StringUtils' rel='sol.common.StringUtils' class='docClass'>sol.common.StringUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils' target='_blank'>lib_sol.common.RepoUtils.js</a></div></pre><div class='doc-contents'><p>This class provides basic functionality for repository operations.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-bom' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-property-bom' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-property-bom' class='name expandable'>bom</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;\\uFEFF&quot;</code></p></div></div></div><div id='property-contentTypeExtensions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-property-contentTypeExtensions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-property-contentTypeExtensions' class='name expandable'>contentTypeExtensions</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{bmp: &quot;image/bmp&quot;, ico: &quot;image/x-ico&quot;, jpg: &quot;image/jpeg&quot;, png: &quot;image/png&quot;}</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div><div id='property-pilcrow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-property-pilcrow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-property-pilcrow' class='name expandable'>pilcrow</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>ByteOrderMark (BOM); ...</div><div class='long'><p>ByteOrderMark (BOM);</p>\n<p>Defaults to: <code>&quot;\\u00b6&quot;</code></p></div></div></div><div id='property-replacementChar' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-property-replacementChar' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-property-replacementChar' class='name expandable'>replacementChar</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;\\uFFFD&quot;</code></p></div></div></div><div id='property-specialFolders' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-property-specialFolders' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-property-specialFolders' class='name expandable'>specialFolders</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Special folders that can be referenced by GUIDs ...</div><div class='long'><p>Special folders that can be referenced by GUIDs</p>\n<p>Defaults to: <code>{administrationFolder: [&quot;ARCPATH[(E10E1000-E100-E100-E100-E10E10E10E00)]:&quot;, &quot;ARCPATH:/Administration&quot;], bsFolder: [&quot;ARCPATH[(E10E1000-E100-E100-E100-B10B10B10B00)]:&quot;, &quot;{{administrationFolderPath}}/Business Solutions&quot;], jcScriptingBaseFolder: [&quot;ARCPATH[(E10E1000-E100-E100-E100-E10E10E10E11)]:&quot;, &quot;{{administrationFolderPath}}/Java Client Scripting Base&quot;], ixScriptingBaseFolder: [&quot;ARCPATH[(E10E1000-E100-E100-E100-E10E10E10E12)]:&quot;, &quot;{{administrationFolderPath}}/IndexServer Scripting Base&quot;], webClientScriptingBaseFolder: [&quot;ARCPATH[(E10E1000-E100-E100-E100-E10E10E10E16)]&quot;, &quot;{{administrationFolderPath}}/Webclient Scripting Base&quot;], localizationBaseFolder: [&quot;ARCPATH[(E10E1000-E100-E100-E100-E10E10E10E1A)]:&quot;, &quot;{{administrationFolderPath}}/Localization&quot;], asBaseFolder: [&quot;{{administrationFolderPath}}/ELOas Base&quot;], wfBaseFolder: [&quot;{{administrationFolderPath}}/ELOwf Base&quot;], appsBaseFolder: [&quot;{{administrationFolderPath}}/ELOapps&quot;]}</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-addColors' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-addColors' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-addColors' class='name expandable'>addColors</a>( <span class='pre'>newColors</span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Adds colors, if they doesn't exist ...</div><div class='long'><p>Adds colors, if they doesn't exist</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>newColors</span> : Array<div class='sub-desc'><p>Colors, example: [{ name: \"sol.solution.processed\", rgb: \"2129920\" }]</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-buildOrValuesSearchString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-buildOrValuesSearchString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-buildOrValuesSearchString' class='name expandable'>buildOrValuesSearchString</a>( <span class='pre'>values</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Builds a search value string for an OR search ...</div><div class='long'><p>Builds a search value string for an OR search</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>values</span> : Array<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-calcNextVersion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-calcNextVersion' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-calcNextVersion' class='name expandable'>calcNextVersion</a>( <span class='pre'>objId, [increaseBy]</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Calculates the next version number of a document. ...</div><div class='long'><p>Calculates the next version number of a document.</p>\n\n<pre><code>newVersion = <a href=\"#!/api/sol.common.RepoUtils-method-calcNextVersion\" rel=\"sol.common.RepoUtils-method-calcNextVersion\" class=\"docClass\">sol.common.RepoUtils.calcNextVersion</a>(\"4711\", 1);\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>increaseBy</span> : Number (optional)<div class='sub-desc'><p>Increase by</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>New version</p>\n</div></li></ul></div></div></div><div id='method-changePathSeparator' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-changePathSeparator' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-changePathSeparator' class='name expandable'>changePathSeparator</a>( <span class='pre'>path, newSeparator</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Changes the path separator ...</div><div class='long'><p>Changes the path separator</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>path</span> : String<div class='sub-desc'><p>Repository path</p>\n</div></li><li><span class='pre'>newSeparator</span> : String<div class='sub-desc'><p>New separator</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Repository path that contains the new separator</p>\n</div></li></ul></div></div></div><div id='method-checkRepoPath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-checkRepoPath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-checkRepoPath' class='name expandable'>checkRepoPath</a>( <span class='pre'>repoPath</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks wether the repository path contains an empty path part ...</div><div class='long'><p>Checks wether the repository path contains an empty path part</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>repoPath</span> : String<div class='sub-desc'><p>Repository path</p>\n</div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>Exception</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-checkVersion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-checkVersion' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-checkVersion' class='name expandable'>checkVersion</a>( <span class='pre'>currentVersionString, requiredVersionString</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks the version of ELO components ...</div><div class='long'><p>Checks the version of ELO components</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>currentVersionString</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>requiredVersionString</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Return true if the current version is equal or higher then the required version</p>\n</div></li></ul></div></div></div><div id='method-checkVersions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-checkVersions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-checkVersions' class='name expandable'>checkVersions</a>( <span class='pre'>currentVersionString, requiredMainVersionStrings</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks the versions of ELO components based on the main version. ...</div><div class='long'><p>Checks the versions of ELO components based on the main version.\nFor each main version can be a minimum requirement.\nIf there is no specific requirement for the main current main version, the highest required main version will be checked.</p>\n\n<p>Examples:\n    <a href=\"#!/api/sol.common.RepoUtils-method-checkVersions\" rel=\"sol.common.RepoUtils-method-checkVersions\" class=\"docClass\">sol.common.RepoUtils.checkVersions</a>(\"9.03.26\", [\"9.03.021\", \"10.01.044\"]);  // => true  (min requirement for ELO 9 satisfied)\n    <a href=\"#!/api/sol.common.RepoUtils-method-checkVersions\" rel=\"sol.common.RepoUtils-method-checkVersions\" class=\"docClass\">sol.common.RepoUtils.checkVersions</a>(\"10.01.38\", [\"9.03.021\", \"10.01.044\"]); // => false (min requirement for ELO 10 not satisfied)\n    <a href=\"#!/api/sol.common.RepoUtils-method-checkVersions\" rel=\"sol.common.RepoUtils-method-checkVersions\" class=\"docClass\">sol.common.RepoUtils.checkVersions</a>(\"11.00.02\", [\"9.03.021\", \"10.01.044\"]); // => true  (no min requirement for ELO 11, but version is higher than '10.01.044')</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>currentVersionString</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>requiredMainVersionStrings</span> : String[]<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Return true if the current version is equal or higher then the required version</p>\n</div></li></ul></div></div></div><div id='method-colorExists' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-colorExists' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-colorExists' class='name expandable'>colorExists</a>( <span class='pre'>colorName</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether a color exists ...</div><div class='long'><p>Checks wether a color exists</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>colorName</span> : String<div class='sub-desc'><p>Color name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-copySords' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-copySords' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-copySords' class='name expandable'>copySords</a>( <span class='pre'>startIds, newParentId, params</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Copy Sords ...</div><div class='long'><p>Copy Sords</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>startIds</span> : Array|String<div class='sub-desc'><p>Start object IDs</p>\n</div></li><li><span class='pre'>newParentId</span> : String<div class='sub-desc'><p>New parent object ID</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>parameters</p>\n<ul><li><span class='pre'>targetName</span> : String<div class='sub-desc'><p>Target name</p>\n</div></li><li><span class='pre'>copyOnlyBaseElement</span> : Boolean (optional)<div class='sub-desc'><p>If true only the base element will be copied</p>\n<p>Defaults to: <code>true</code></p></div></li><li><span class='pre'>copyOnlyWorkversion</span> : Boolean (optional)<div class='sub-desc'><p>If true only the work version will be copied</p>\n<p>Defaults to: <code>true</code></p></div></li><li><span class='pre'>copyStructuresAndDocuments</span> : Boolean (optional)<div class='sub-desc'><p>If true structures and documents will be copied</p>\n<p>Defaults to: <code>true</code></p></div></li><li><span class='pre'>takeTargetPermissions</span> : Boolean (optional)<div class='sub-desc'><p>If true the target permissions will be set</p>\n<p>Defaults to: <code>true</code></p></div></li><li><span class='pre'>keepOriginalPermissions</span> : Boolean (optional)<div class='sub-desc'><p>If true the original permissions will be kept</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>keepOriginalPermissions</span> : Boolean (optional)<div class='sub-desc'><p>If true the original permissions will be kept</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>connection</span> : de.elo.ix.client.IXConnection (optional)<div class='sub-desc'><p>Index server connection</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createConnFact' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-createConnFact' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-createConnFact' class='name expandable'>createConnFact</a>( <span class='pre'>connProps, sessOpts, overrideParams</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates a new connection factory ...</div><div class='long'><p>Creates a new connection factory</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>connProps</span> : java.util.Properties<div class='sub-desc'><p>Connection properties</p>\n</div></li><li><span class='pre'>sessOpts</span> : java.util.Properties<div class='sub-desc'><p>Session options</p>\n</div></li><li><span class='pre'>overrideParams</span> : Object<div class='sub-desc'><p>Overide Parameters</p>\n<ul><li><span class='pre'>conn</span> : de.elo.ix.client.IXConnection<div class='sub-desc'><p>Connection</p>\n</div></li><li><span class='pre'>connProps</span> : Object<div class='sub-desc'><p>Change connection properties</p>\n</div></li><li><span class='pre'>timeoutSeconds</span> : Number<div class='sub-desc'><p>Timeout seconds</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Example:</p>\n\n<pre><code>conn = <a href=\"#!/api/sol.common.RepoUtils-method-createConnFact\" rel=\"sol.common.RepoUtils-method-createConnFact\" class=\"docClass\">sol.common.RepoUtils.createConnFact</a>(connProps, sessOpts, {\n  timeoutSeconds: 300\n});\n</code></pre>\n</div></li></ul></div></div></div><div id='method-createExternalLink' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-createExternalLink' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-createExternalLink' class='name expandable'>createExternalLink</a>( <span class='pre'>params</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates an external link ...</div><div class='long'><p>Creates an external link</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>limitTo</span> : String<div class='sub-desc'><p>Limit to</p>\n</div></li><li><span class='pre'>limitToUnit</span> : String (optional)<div class='sub-desc'><p>Limit to unit, e.g. days</p>\n<p>Defaults to: <code>d</code></p></div></li><li><span class='pre'>times</span> : Number<div class='sub-desc'><p>times Times</p>\n</div></li><li><span class='pre'>escapeXml</span> : Boolean (optional)<div class='sub-desc'><p>Escape the URL for use in XML</p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>URL</p>\n</div></li></ul></div></div></div><div id='method-createObjKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-createObjKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-createObjKey' class='name expandable'>createObjKey</a>( <span class='pre'>id, name, value</span> ) : de.elo.ix.client.ObjKey<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Creates an ObjKey object ...</div><div class='long'><p>Creates an ObjKey object</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : String<div class='sub-desc'><p>ID of the ObjKey</p>\n</div></li><li><span class='pre'>name</span> : String<div class='sub-desc'><p>Name of the ObjKey</p>\n</div></li><li><span class='pre'>value</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.ObjKey</span><div class='sub-desc'><p>Created ObjKey</p>\n</div></li></ul></div></div></div><div id='method-createPath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-createPath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-createPath' class='name expandable'>createPath</a>( <span class='pre'>repoPath, [params]</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates a repository path. ...</div><div class='long'><p>Creates a repository path.</p>\n\n<p>If the path contains dynamic content, use <a href=\"#!/api/sol.common.RepoUtils-method-preparePath\" rel=\"sol.common.RepoUtils-method-preparePath\" class=\"docClass\">preparePath</a> instead.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>repoPath</span> : String<div class='sub-desc'><p>A path. The path separator is defined by the first character or the first character after \"ARCPATH:\"</p>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'>\n<ul><li><span class='pre'>mask</span> : String (optional)<div class='sub-desc'><p>If set, newly created parts of the path get that mask</p>\n</div></li><li><span class='pre'>rightsConfig</span> : Object<div class='sub-desc'><p>Rights configuration</p>\n</div></li><li><span class='pre'>sordType</span> : String|Number<div class='sub-desc'><p>Name or ID of a sord type which will be set on all new elements</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The ID of the new element, or null if something went wrong</p>\n</div></li></ul></div></div></div><div id='method-createTempFileWithSordName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-createTempFileWithSordName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-createTempFileWithSordName' class='name expandable'>createTempFileWithSordName</a>( <span class='pre'>objId</span> ) : java.io.File<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates a temp file from a repository document with it's element name as file name\nand downloads the document ...</div><div class='long'><p>Creates a temp file from a repository document with it's element name as file name\nand downloads the document</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID of the repository document.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.io.File</span><div class='sub-desc'><p>Temporary file.</p>\n</div></li></ul></div></div></div><div id='method-deleteAllReferences' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-deleteAllReferences' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-deleteAllReferences' class='name expandable'>deleteAllReferences</a>( <span class='pre'>sord</span> ) : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>Deletes all references ...</div><div class='long'><p>Deletes all references</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'><p>Reference parent IDs</p>\n</div></li></ul></div></div></div><div id='method-deleteSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-deleteSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-deleteSord' class='name expandable'>deleteSord</a>( <span class='pre'>objId, config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Deletes a sord ...</div><div class='long'><p>Deletes a sord</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>parentId</span> : Object<div class='sub-desc'><p>parentId Parent ID</p>\n</div></li><li><span class='pre'>deleteFinally</span> : Boolean<div class='sub-desc'>\n</div></li><li><span class='pre'>silent</span> : Boolean<div class='sub-desc'>\n</div></li></ul></div></li></ul></div></div></div><div id='method-detectScriptEnvironment' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-detectScriptEnvironment' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-detectScriptEnvironment' class='name expandable'>detectScriptEnvironment</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Detects the runtime context ...</div><div class='long'><p>Detects the runtime context</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Context, ´JC´, ´AS´ or ´IX´</p>\n</div></li></ul></div></div></div><div id='method-determinateSpecialFolders' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-determinateSpecialFolders' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-determinateSpecialFolders' class='name expandable'>determinateSpecialFolders</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Determinates special folders by its GUID or alternatively by a default path ...</div><div class='long'><p>Determinates special folders by its GUID or alternatively by a default path</p>\n</div></div></div><div id='method-downloadSmallContentToString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-downloadSmallContentToString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-downloadSmallContentToString' class='name expandable'>downloadSmallContentToString</a>( <span class='pre'>objId, docId</span> ) : java.lang.String<span class=\"signature\"></span></div><div class='description'><div class='short'>Downloads the content of a small repository document into a string ...</div><div class='long'><p>Downloads the content of a small repository document into a string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID of the document. If a document version should be loaded, this has to be null</p>\n</div></li><li><span class='pre'>docId</span> : String<div class='sub-desc'><p>If a docId is supplied, the function will try to download the version only, if objId is null.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.lang.String</span><div class='sub-desc'><p>Content as string.</p>\n</div></li></ul></div></div></div><div id='method-downloadToBase64String' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-downloadToBase64String' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-downloadToBase64String' class='name expandable'>downloadToBase64String</a>( <span class='pre'>objId, docId</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Downloads the content of a repository document into a base64 string ...</div><div class='long'><p>Downloads the content of a repository document into a base64 string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID of the document. If a document version should be loaded, this has to be null</p>\n</div></li><li><span class='pre'>docId</span> : String<div class='sub-desc'><p>If a docId is supplied, the function will try to download the version only, if objId is null.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Content as base64 string.</p>\n</div></li></ul></div></div></div><div id='method-downloadToByteArray' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-downloadToByteArray' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-downloadToByteArray' class='name expandable'>downloadToByteArray</a>( <span class='pre'>objId, docId, [params]</span> ) : java.lang.Byte[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Downloads the content of a repository document into a byte array ...</div><div class='long'><p>Downloads the content of a repository document into a byte array</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID of the document. If a document version should be loaded, this has to be null</p>\n</div></li><li><span class='pre'>docId</span> : String<div class='sub-desc'><p>If a docId is supplied, the function will try to download the version only, if objId is null.</p>\n</div></li><li><span class='pre'>params</span> : de.elo.ix.client.IXConnection (optional)<div class='sub-desc'>\n<ul><li><span class='pre'>connection</span> : de.elo.ix.client.IXConnection (optional)<div class='sub-desc'><p>Index server connection</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.lang.Byte[]</span><div class='sub-desc'><p>Content as byte array.</p>\n</div></li></ul></div></div></div><div id='method-downloadToFile' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-downloadToFile' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-downloadToFile' class='name expandable'>downloadToFile</a>( <span class='pre'>objId, config</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Downloads a document from the repository ...</div><div class='long'><p>Downloads a document from the repository</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID of the document</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>dstDirPath</span> : String (optional)<div class='sub-desc'><p>Destination directory path. <code>config.fileName</code> must also be set.</p>\n</div></li><li><span class='pre'>fileName</span> : String (optional)<div class='sub-desc'><p>File name</p>\n</div></li><li><span class='pre'>extension</span> : String (optional)<div class='sub-desc'><p>Extention</p>\n</div></li><li><span class='pre'>file</span> : java.io.File (optional)<div class='sub-desc'><p>Destination file</p>\n</div></li><li><span class='pre'>createUniqueFileName</span> : Boolean (optional)<div class='sub-desc'><p>If true the filename will be extended by a number if necessary</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Path of the downloaded file</p>\n</div></li></ul></div></div></div><div id='method-downloadToFileData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-downloadToFileData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-downloadToFileData' class='name expandable'>downloadToFileData</a>( <span class='pre'>objId, docId, config</span> ) : java.io.InputStream<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>docId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>extension</span> : String<div class='sub-desc'><p>Extension</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.io.InputStream</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-downloadToStream' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-downloadToStream' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-downloadToStream' class='name expandable'>downloadToStream</a>( <span class='pre'>objId, docId, params</span> ) : java.io.InputStream<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>docId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>connection</span> : de.elo.ix.client.IXConnection<div class='sub-desc'>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.io.InputStream</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-downloadToString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-downloadToString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-downloadToString' class='name expandable'>downloadToString</a>( <span class='pre'>objId, docId, [params]</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Downloads the content of a repository document into a string ...</div><div class='long'><p>Downloads the content of a repository document into a string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID of the document. If a document version should be loaded, this has to be null</p>\n</div></li><li><span class='pre'>docId</span> : String<div class='sub-desc'><p>If a docId is supplied, the function will try to download the version only, if objId is null.</p>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'><p>Additional parameter</p>\n<ul><li><span class='pre'>preserveBOM</span> : Boolean (optional)<div class='sub-desc'><p>If <code>true</code>, the BOM will not be removed (if present)</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>connection</span> : de.elo.ix.client.IXConnection (optional)<div class='sub-desc'><p>Index server connection</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Content as string.</p>\n</div></li></ul></div></div></div><div id='method-exists' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-exists' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-exists' class='name expandable'>exists</a>( <span class='pre'>repoPath</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether a path exists ...</div><div class='long'><p>Checks wether a path exists</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>repoPath</span> : String<div class='sub-desc'><p>Repository path</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-exportRepoData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-exportRepoData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-exportRepoData' class='name expandable'>exportRepoData</a>( <span class='pre'>exportZipFile, exportOptions</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Exports a repository folder into an ELO ZIP file ...</div><div class='long'><p>Exports a repository folder into an ELO ZIP file</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>exportZipFile</span> : java.io.File<div class='sub-desc'>\n</div></li><li><span class='pre'>exportOptions</span> : Object<div class='sub-desc'><p>Export options, see de.elo.ix.client.ExportExtOptions</p>\n</div></li></ul></div></div></div><div id='method-findChildren' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-findChildren' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-findChildren' class='name expandable'>findChildren</a>( <span class='pre'>objId, config, [ixConn]</span> ) : de.elo.ix.client.Sord[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Finds the children of an element. ...</div><div class='long'><p>Finds the children of an element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>includeFolders</span> : Boolean<div class='sub-desc'>\n</div></li><li><span class='pre'>includeDocuments</span> : Boolean<div class='sub-desc'>\n</div></li><li><span class='pre'>includeReferences</span> : Boolean (optional)<div class='sub-desc'>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>sordZ</span> : de.elo.ix.client.SordZ (optional)<div class='sub-desc'><p><code>SordC.mbOnlyId</code> and <code>SordC.mbOnlyGuid</code> are not working</p>\n<p>Defaults to: <code>SordC.mbAll</code></p></div></li><li><span class='pre'>recursive</span> : Boolean (optional)<div class='sub-desc'><p>If true, subfolders will be included (use carefully)</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>level</span> : Number (optional)<div class='sub-desc'><p>If subfolders are included, this restricts the search depth (<code>-1</code> for max. depth)</p>\n<p>Defaults to: <code>3</code></p></div></li><li><span class='pre'>maskId</span> : String (optional)<div class='sub-desc'><p>If set, find objects related to this mask ID or name</p>\n</div></li><li><span class='pre'>maskIds</span> : String[] (optional)<div class='sub-desc'><p>If set, find objects related to these mask IDs or names</p>\n</div></li><li><span class='pre'>findOptions</span> : de.elo.ix.client.FindOptions (optional)<div class='sub-desc'><p>If set, this <code>FindOptions</code> will be applied the the search</p>\n</div></li><li><span class='pre'>objKeysObj</span> : Object (optional)<div class='sub-desc'><p>Find by values</p>\n</div></li><li><span class='pre'>name</span> : String (optional)<div class='sub-desc'><p>Filters the result by the sord name (all elements containing <code>name</code>, for exact matches see <code>exactName</code>)</p>\n</div></li><li><span class='pre'>ownerId</span> : String (optional)<div class='sub-desc'><p>Filters the result by the owner ID</p>\n</div></li><li><span class='pre'>exactName</span> : Boolean (optional)<div class='sub-desc'><p>If this is <code>true</code>, only objects will be returned, where the name matches exactly <code>name</code></p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></li><li><span class='pre'>ixConn</span> : de.elo.ix.client.IXConnection (optional)<div class='sub-desc'><p>This will be used instead of <code>ìxConnect</code> (usfull when the search should run in a different user context)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-findIds' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-findIds' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-findIds' class='name expandable'>findIds</a>( <span class='pre'>findInfo, params</span> ) : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns object IDs by a given ´findInfo´ object ...</div><div class='long'><p>Returns object IDs by a given ´findInfo´ object</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>findInfo</span> : de.elo.ix.client.FindInfo<div class='sub-desc'><p>Find info</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>findMax</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>sordZ</span> : de.elo.ix.client.SordZ<div class='sub-desc'><p>SordZ</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-findInHierarchy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-findInHierarchy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-findInHierarchy' class='name expandable'>findInHierarchy</a>( <span class='pre'>objId, config</span> ) : de.elo.ix.client.Sord<span class=\"signature\"></span></div><div class='description'><div class='short'>Find a sord in the hierarchy ...</div><div class='long'><p>Find a sord in the hierarchy</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Optional parameters</p>\n<ul><li><span class='pre'>sordTypeNames</span> : String[]<div class='sub-desc'><p>Name of sord types</p>\n</div></li><li><span class='pre'>objKeyName</span> : String<div class='sub-desc'><p>Name of the oject key</p>\n</div></li><li><span class='pre'>objKeyValues</span> : String[]<div class='sub-desc'><p>Values of the object key</p>\n</div></li><li><span class='pre'>connection</span> : de.elo.ix.client.IXConnection<div class='sub-desc'><p>Index server connection</p>\n</div></li><li><span class='pre'>sordZ</span> : de.elo.ix.client.SordZ<div class='sub-desc'><p>Element selector</p>\n</div></li><li><span class='pre'>throwException</span> : Boolean<div class='sub-desc'><p>If true a exception is thrown if no sord was found</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord</span><div class='sub-desc'><p>Sord</p>\n</div></li></ul></div></div></div><div id='method-findObjectTypeInHierarchy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-findObjectTypeInHierarchy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-findObjectTypeInHierarchy' class='name expandable'>findObjectTypeInHierarchy</a>( <span class='pre'>objId, values, config</span> ) : de.elo.ix.client.Sord<span class=\"signature\"></span></div><div class='description'><div class='short'>Finds a sord in the hierarchy by the index field 'SOL_TYPE' ...</div><div class='long'><p>Finds a sord in the hierarchy by the index field 'SOL_TYPE'</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>values</span> : String[]<div class='sub-desc'><p>Values</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>connection</span> : de.elo.ix.client.IXConnection<div class='sub-desc'><p>Index server connection</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord</span><div class='sub-desc'><p>Sord</p>\n</div></li></ul></div></div></div><div id='method-findSords' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-findSords' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-findSords' class='name expandable'>findSords</a>( <span class='pre'>params</span> ) : de.elo.ix.client.Sord[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Finds sords ...</div><div class='long'><p>Finds sords</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>objKeysObj</span> : Object<div class='sub-desc'><p>Map that contains key-value pairs or objects\n    Example:\n    {\n      \"objKeysObj\": {\n        \"VISITOR_STATUS\": \"PR*\"\n        \"SOL_TYPE\": { value: '\"VISITOR\" OR \"VISITOR_GROUP\" OR \"VISITOR_COMPANY\" OR \"LONG_TERM_BADGE\"', oneTerm: false }\n      }\n    }\n    If <code>oneTerm</code>is true, then the value is treated as one whole string.</p>\n</div></li><li><span class='pre'>maskId</span> : String (optional)<div class='sub-desc'><p>If set, find objects related to this mask ID or name</p>\n</div></li><li><span class='pre'>maskIds</span> : String[] (optional)<div class='sub-desc'><p>If set, find objects related to these mask IDs or names</p>\n</div></li><li><span class='pre'>sordZ</span> : de.elo.ix.client.SordZ (optional)<div class='sub-desc'><p><code>SordC.mbOnlyId</code> and <code>SordC.mbOnlyGuid</code> are not working</p>\n<p>Defaults to: <code>SordC.mbAll</code></p></div></li><li><span class='pre'>ixConn</span> : de.elo.ix.client.IXConnection (optional)<div class='sub-desc'><p>This will be used instead of <code>ìxConnect</code> (usfull when the search should run in a different user context)</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getColorId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getColorId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getColorId' class='name expandable'>getColorId</a>( <span class='pre'>colorName</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the color ID ...</div><div class='long'><p>Returns the color ID</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>colorName</span> : String<div class='sub-desc'><p>Color name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Color ID</p>\n</div></li></ul></div></div></div><div id='method-getDownloadUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getDownloadUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getDownloadUrl' class='name expandable'>getDownloadUrl</a>( <span class='pre'>objId, docId, params</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>docId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>connection</span> : de.elo.ix.client.IXConnection<div class='sub-desc'>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getFirstChild' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getFirstChild' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getFirstChild' class='name expandable'>getFirstChild</a>( <span class='pre'>config</span> ) : de.elo.ix.client.Sord<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the first child ...</div><div class='long'><p>Returns the first child</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Config</p>\n<ul><li><span class='pre'>parentId</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>Parent Sord ID</p>\n</div></li><li><span class='pre'>includeDocuments</span> : Boolean (optional)<div class='sub-desc'><p>Include documents</p>\n<p>Defaults to: <code>true</code></p></div></li><li><span class='pre'>includeFolders</span> : Boolean (optional)<div class='sub-desc'><p>Include folders</p>\n<p>Defaults to: <code>true</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord</span><div class='sub-desc'><p>First child</p>\n</div></li></ul></div></div></div><div id='method-getGuid' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getGuid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getGuid' class='name expandable'>getGuid</a>( <span class='pre'>objId</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the object GUID of a given Object ID ...</div><div class='long'><p>Returns the object GUID of a given Object ID</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>GUID</p>\n</div></li></ul></div></div></div><div id='method-getIxId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getIxId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getIxId' class='name expandable'>getIxId</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the IX ID ...</div><div class='long'><p>Returns the IX ID</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>IX ID</p>\n</div></li></ul></div></div></div><div id='method-getIxOption' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getIxOption' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getIxOption' class='name expandable'>getIxOption</a>( <span class='pre'>key</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns IX options ...</div><div class='long'><p>Returns IX options</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : String<div class='sub-desc'><p>Key</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>entry Entry</p>\n</div></li></ul></div></div></div><div id='method-getIxOptions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getIxOptions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getIxOptions' class='name expandable'>getIxOptions</a>( <span class='pre'></span> ) : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the IX options ...</div><div class='long'><p>Returns the IX options</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'><p>IX options</p>\n</div></li></ul></div></div></div><div id='method-getNameFromPath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getNameFromPath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getNameFromPath' class='name expandable'>getNameFromPath</a>( <span class='pre'>repoPath</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the name part of a repository path ...</div><div class='long'><p>Returns the name part of a repository path</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>repoPath</span> : String<div class='sub-desc'><p>Repository path</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Name part of the repository path</p>\n</div></li></ul></div></div></div><div id='method-getObjId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getObjId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getObjId' class='name expandable'>getObjId</a>( <span class='pre'>path, params</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the object ID of a given repository path ...</div><div class='long'><p>Returns the object ID of a given repository path</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>path</span> : String<div class='sub-desc'><p>Repository path. The path separator is defined by the first character or the first charcter after \"ARCPATH:\"</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>resolveGuid</span> : Boolean<div class='sub-desc'><p>Resolve GUID</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The ID of the new element, or null if it does not exist</p>\n</div></li></ul></div></div></div><div id='method-getObjIdByIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getObjIdByIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getObjIdByIndex' class='name expandable'>getObjIdByIndex</a>( <span class='pre'>filter</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Looks up an objId by an index field value. ...</div><div class='long'><p>Looks up an objId by an index field value.</p>\n\n<pre><code><a href=\"#!/api/sol.common.RepoUtils-method-getObjIdByIndex\" rel=\"sol.common.RepoUtils-method-getObjIdByIndex\" class=\"docClass\">sol.common.RepoUtils.getObjIdByIndex</a>( { mask: \"Invoice\", objKeyData: [ { key: \"INVOICE_ID\", value: \"12345\" } ] } );\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>filter</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>mask</span> : String (optional)<div class='sub-desc'><p>Additional limit search by mask</p>\n</div></li><li><span class='pre'>objKeyData</span> : Object[]<div class='sub-desc'><p>Objects with key and value for the lookup</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The objId</p>\n</div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Throws an exception, if result is not unique</p>\n</div></li><li><span class='pre'>Object</span><div class='sub-desc'><p>Throws an exception, if there is no result</p>\n</div></li></ul></div></div></div><div id='method-getObjIdFromRelativePath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getObjIdFromRelativePath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getObjIdFromRelativePath' class='name expandable'>getObjIdFromRelativePath</a>( <span class='pre'>startFolderId, relativePath</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the object ID of an object which is defined by a start object and an additional relative path\n\n   var objId =...</div><div class='long'><p>Returns the object ID of an object which is defined by a start object and an additional relative path</p>\n\n<p>   var objId = <a href=\"#!/api/sol.common.RepoUtils-method-getObjIdFromRelativePath\" rel=\"sol.common.RepoUtils-method-getObjIdFromRelativePath\" class=\"docClass\">sol.common.RepoUtils.getObjIdFromRelativePath</a>(123, \"/.eloinst\");\n   var objId = sol.common.RepoUtils.getObjIdFromath(\"ARCPATH:/Administration\", \"/common/Configuration\");</p>\n\n<p>If the start folder is adynamic register, this method handels the request a little different:</p>\n\n<ul>\n<li>it determines all children</li>\n<li>it searches for a child element with the name specified by 'ath'</li>\n<li>unlike the same call on a normal folder, this does not support nested paths (i.e. <code>ath</code> can just have one level)</li>\n</ul>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>startFolderId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>relativePath</span> : String<div class='sub-desc'><p>Should start with a separator</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getObjIdFromRelativeSolutionPath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getObjIdFromRelativeSolutionPath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getObjIdFromRelativeSolutionPath' class='name expandable'>getObjIdFromRelativeSolutionPath</a>( <span class='pre'>relativePath</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the object ID of an object which is defined by a relative solution path. ...</div><div class='long'><p>Returns the object ID of an object which is defined by a relative solution path.\nSearches in the folders which are defined in /common/Configuration/base.config in baseMergePaths.\nStarts searching from behind.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>relativePath</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getParentPath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getParentPath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getParentPath' class='name expandable'>getParentPath</a>( <span class='pre'>repoPath</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the parent repository path ...</div><div class='long'><p>Returns the parent repository path</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>repoPath</span> : String<div class='sub-desc'><p>Repository path</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Repository path of the parent folder</p>\n</div></li></ul></div></div></div><div id='method-getPath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getPath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getPath' class='name expandable'>getPath</a>( <span class='pre'>sord, withPrefix, [config]</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns repository path of a Sord object ...</div><div class='long'><p>Returns repository path of a Sord object</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>withPrefix</span> : Boolean<div class='sub-desc'><p>If true the ARCPATH: prefix will be added.</p>\n</div></li><li><span class='pre'>config</span> : Object (optional)<div class='sub-desc'>\n<ul><li><span class='pre'>separator</span> : String (optional)<div class='sub-desc'>\n<p>Defaults to: <code>&quot;/&quot;</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Repository path</p>\n</div></li></ul></div></div></div><div id='method-getPathFromObjId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getPathFromObjId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getPathFromObjId' class='name expandable'>getPathFromObjId</a>( <span class='pre'>objId, [config]</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns repository path of an object ID ...</div><div class='long'><p>Returns repository path of an object ID</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>config</span> : Object (optional)<div class='sub-desc'>\n<ul><li><span class='pre'>separator</span> : String (optional)<div class='sub-desc'>\n<p>Defaults to: <code>&quot;/&quot;</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Repository path</p>\n</div></li></ul></div></div></div><div id='method-getPathSeparator' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getPathSeparator' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getPathSeparator' class='name expandable'>getPathSeparator</a>( <span class='pre'>repoPath</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the repository path separator character ...</div><div class='long'><p>Returns the repository path separator character</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>repoPath</span> : String<div class='sub-desc'><p>Repository path</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Repository path separator</p>\n</div></li></ul></div></div></div><div id='method-getRepoPathObjIds' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getRepoPathObjIds' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getRepoPathObjIds' class='name expandable'>getRepoPathObjIds</a>( <span class='pre'>objId</span> ) : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the object IDs of the repository path elements in ascending order ...</div><div class='long'><p>Returns the object IDs of the repository path elements in ascending order</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>object ID</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'><p>Array of object IDs</p>\n</div></li></ul></div></div></div><div id='method-getSessionOptions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getSessionOptions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getSessionOptions' class='name expandable'>getSessionOptions</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Get session options ...</div><div class='long'><p>Get session options</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getSord' class='name expandable'>getSord</a>( <span class='pre'>objId, [params]</span> ) : de.elo.ix.client.Sord<span class=\"signature\"></span></div><div class='description'><div class='short'>Checkout a Sord. ...</div><div class='long'><p>Checkout a Sord.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Can be an objId, a GUID or an ARCPATH</p>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'>\n<ul><li><span class='pre'>connection</span> : de.elo.ix.client.IXConnection (optional)<div class='sub-desc'><p>Index server connection</p>\n</div></li><li><span class='pre'>sordZ</span> : de.elo.ix.client.SordZ (optional)<div class='sub-desc'>\n<p>Defaults to: <code>SordC.mbAllIndex</code></p></div></li><li><span class='pre'>lockZ</span> : de.elo.ix.client.LockZ (optional)<div class='sub-desc'>\n<p>Defaults to: <code>LockC.NO</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSords' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getSords' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getSords' class='name expandable'>getSords</a>( <span class='pre'>objIds, [config]</span> ) : de.elo.ix.client.Sord[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns sords by object IDs ...</div><div class='long'><p>Returns sords by object IDs</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objIds</span> : Array<div class='sub-desc'><p>Object IDs</p>\n</div></li><li><span class='pre'>config</span> : Object (optional)<div class='sub-desc'>\n<ul><li><span class='pre'>connection</span> : de.elo.ix.client.IXConnection (optional)<div class='sub-desc'><p>Index server connection</p>\n</div></li><li><span class='pre'>sordZ</span> : de.elo.ix.client.SordZ (optional)<div class='sub-desc'>\n<p>Defaults to: <code>SordC.mbAllIndex</code></p></div></li><li><span class='pre'>keepOrder</span> : Boolean (optional)<div class='sub-desc'><p>Keep the order of the Sords</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord[]</span><div class='sub-desc'><p>Sords</p>\n</div></li></ul></div></div></div><div id='method-getValidParent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-getValidParent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-getValidParent' class='name expandable'>getValidParent</a>( <span class='pre'>objId, type, values</span> ) : de.elo.ix.client.Sord.id<span class=\"signature\"></span></div><div class='description'><div class='short'>Finds a valid parent of a sord with specified index field ...</div><div class='long'><p>Finds a valid parent of a sord with specified index field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>type</span> : String<div class='sub-desc'><p>Name of group</p>\n</div></li><li><span class='pre'>values</span> : String[]<div class='sub-desc'><p>Values</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord.id</span><div class='sub-desc'><p>objId</p>\n</div></li></ul></div></div></div><div id='method-importRepoData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-importRepoData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-importRepoData' class='name expandable'>importRepoData</a>( <span class='pre'>importZipFile, dstRepoPath, guidMethod, options</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Imports a ELO ZIP file into the repository ...</div><div class='long'><p>Imports a ELO ZIP file into the repository</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>importZipFile</span> : java.io.File<div class='sub-desc'>\n</div></li><li><span class='pre'>dstRepoPath</span> : String<div class='sub-desc'><p>Destination repository path</p>\n</div></li><li><span class='pre'>guidMethod</span> : Number<div class='sub-desc'><p>GUID method, see de.elo.ix.client.ImportOptionsC</p>\n</div></li><li><span class='pre'>options</span> : Number<div class='sub-desc'><p>Import options, see de.elo.ix.client.ImportOptionsC</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-isArcpath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-isArcpath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-isArcpath' class='name expandable'>isArcpath</a>( <span class='pre'>str</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns true if the given string is an arcpath ...</div><div class='long'><p>Returns true if the given string is an arcpath</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>Input string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isGuid' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-isGuid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-isGuid' class='name expandable'>isGuid</a>( <span class='pre'>str</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns true if the given string is an object ID ...</div><div class='long'><p>Returns true if the given string is an object ID</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>Input string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isLMatchPath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-isLMatchPath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-isLMatchPath' class='name expandable'>isLMatchPath</a>( <span class='pre'>str</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-isMd5HashPath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-isMd5HashPath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-isMd5HashPath' class='name expandable'>isMd5HashPath</a>( <span class='pre'></span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns true if the given string is an md5 hash path ...</div><div class='long'><p>Returns true if the given string is an md5 hash path</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'></span> : Object<div class='sub-desc'><p>(String) str Input string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isObjId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-isObjId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-isObjId' class='name expandable'>isObjId</a>( <span class='pre'>str</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns true if the given string is an object ID ...</div><div class='long'><p>Returns true if the given string is an object ID</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>Input string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isOkeyPath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-isOkeyPath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-isOkeyPath' class='name expandable'>isOkeyPath</a>( <span class='pre'>str</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns true if the given string is an okay path ...</div><div class='long'><p>Returns true if the given string is an okay path</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>Input string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isRepoId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-isRepoId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-isRepoId' class='name expandable'>isRepoId</a>( <span class='pre'>str</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns true if str is a possible elo object identifier. ...</div><div class='long'><p>Returns true if str is a possible elo object identifier.</p>\n\n<p>Check <code>checkoutSord</code> documentation to see all valid object identifiers</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>Input string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-moveSords' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-moveSords' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-moveSords' class='name expandable'>moveSords</a>( <span class='pre'>objIds, dstFolderId, params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Moves Sords ...</div><div class='long'><p>Moves Sords</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objIds</span> : Array<div class='sub-desc'><p>Object IDs</p>\n</div></li><li><span class='pre'>dstFolderId</span> : String<div class='sub-desc'><p>Destination folder ID</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>parameters</p>\n<ul><li><span class='pre'>manSortIdx</span> : String (optional)<div class='sub-desc'><p>Manually determine the position</p>\n<p>Defaults to: <code>-1</code></p></div></li><li><span class='pre'>adjustAclOverwrite</span> : String (optional)<div class='sub-desc'><p>Adjust the ACL</p>\n<p>Defaults to: <code>true</code></p></div></li></ul></div></li></ul></div></div></div><div id='method-moveToStoragePath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-moveToStoragePath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-moveToStoragePath' class='name expandable'>moveToStoragePath</a>( <span class='pre'>startObjId, dstStoragePathId</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Moves documents to a given storage path ...</div><div class='long'><p>Moves documents to a given storage path</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>startObjId</span> : String<div class='sub-desc'><p>Start object ID</p>\n</div></li><li><span class='pre'>dstStoragePathId</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-normalizePath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-normalizePath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-normalizePath' class='name expandable'>normalizePath</a>( <span class='pre'>repoPath, withPrefix</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Normalizes a repository path ...</div><div class='long'><p>Normalizes a repository path</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>repoPath</span> : String<div class='sub-desc'><p>Repository path</p>\n</div></li><li><span class='pre'>withPrefix</span> : Boolean<div class='sub-desc'><p>If true the ARCPATH: prefix will be added.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Normalized repository path</p>\n</div></li></ul></div></div></div><div id='method-preparePath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-preparePath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-preparePath' class='name expandable'>preparePath</a>( <span class='pre'>repoPath, [params]</span> ) : String|Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks and creates a repository path. ...</div><div class='long'><p>Checks and creates a repository path.</p>\n\n<p>The <code>repoPath</code> can be in handlebars <a href=\"http://handlebarsjs.com/\">handlebars</a> syntax and is applied via <a href=\"#!/api/sol.common.Template\" rel=\"sol.common.Template\" class=\"docClass\">sol.common.Template</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>repoPath</span> : String<div class='sub-desc'><p>Repository path. The path separator is defined by the first character or the first charcter after \"ARCPATH:\"</p>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'>\n<ul><li><span class='pre'>mask</span> : String (optional)<div class='sub-desc'><p>If set, newly created parts of the path get that mask</p>\n</div></li><li><span class='pre'>returnDetails</span> : Boolean (optional)<div class='sub-desc'><p>If set, the created objId will be returned as an object property. If the path already existed, an additional property existed:true will be returned.</p>\n</div></li><li><span class='pre'>skipIfNotExists</span> : Boolean (optional)<div class='sub-desc'><p>If set and the repoPath does not exist, it will not be created. { objId: null, existed: false, skipped: true } will be returned.</p>\n</div></li><li><span class='pre'>data</span> : Object|de.elo.ix.client.Sord (optional)<div class='sub-desc'><p>If set, this is applied to the repoPath, while the repoPath has to be in <code>handlebars</code> syntax</p>\n</div></li><li><span class='pre'>sordType</span> : String|Number (optional)<div class='sub-desc'><p>Name or ID of a sord type which will be set on all new elements</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String|Object</span><div class='sub-desc'><p>The ID of the new element, or null if something went wrong</p>\n</div></li></ul></div></div></div><div id='method-readColors' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-readColors' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-readColors' class='name expandable'>readColors</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns an object that contains all colors ...</div><div class='long'><p>Returns an object that contains all colors</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Colors</p>\n</div></li></ul></div></div></div><div id='method-resolveSpecialFolder' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-resolveSpecialFolder' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-resolveSpecialFolder' class='name expandable'>resolveSpecialFolder</a>( <span class='pre'>path, paramObj</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Resolve special folders by GUID (see specialFolders)\n\nvar ressourcePath = sol.common.RepoUtils.resolveSpecialFolder(\"...</div><div class='long'><p>Resolve special folders by GUID (see <a href=\"#!/api/sol.common.RepoUtils-property-specialFolders\" rel=\"sol.common.RepoUtils-property-specialFolders\" class=\"docClass\">specialFolders</a>)</p>\n\n<pre><code>var ressourcePath = <a href=\"#!/api/sol.common.RepoUtils-method-resolveSpecialFolder\" rel=\"sol.common.RepoUtils-method-resolveSpecialFolder\" class=\"docClass\">sol.common.RepoUtils.resolveSpecialFolder</a>(\"{{administrationFolderPath}}/Ressources\");\n</code></pre>\n\n<p>Supported variables:</p>\n\n<pre><code>{{administrationFolderPath}}\n{{bsFolderPath}}\n{{jcScriptingBaseFolderPath}}\n{{ixScriptingBaseFolderPath}}\n{{webClientScriptingBaseFolderPath}}\n{{localizationBaseFolderPath}}\n{{asBaseFolderPath}}\n{{wfBaseFolderPath}}\n{{appsBaseFolderPath}}\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>path</span> : String<div class='sub-desc'><p>Path to be resolved</p>\n</div></li><li><span class='pre'>paramObj</span> : Object<div class='sub-desc'><p>Additional properties: packageName, packageBaseFolderPath</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Resolved Path</p>\n</div></li></ul></div></div></div><div id='method-saveToRepo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-saveToRepo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-saveToRepo' class='name expandable'>saveToRepo</a>( <span class='pre'>saveToRepoConfig</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates a new repository document or saves a new version to an existing document. ...</div><div class='long'><p>Creates a new repository document or saves a new version to an existing document.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>saveToRepoConfig</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>name</span> : String<div class='sub-desc'><p>Name</p>\n</div></li><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object which should be updated (<code>parentId</code>, <code>repoPath</code> and <code>tryUpdate</code> are redundant in this case); objId will be used first</p>\n</div></li><li><span class='pre'>parentId</span> : String<div class='sub-desc'><p>Parent folder object ID</p>\n</div></li><li><span class='pre'>repoPath</span> : String<div class='sub-desc'><p>Complete destination repository path</p>\n</div></li><li><span class='pre'>maskId</span> : String<div class='sub-desc'><p>Mask ID</p>\n</div></li><li><span class='pre'>objKeysObj</span> : Object<div class='sub-desc'><p>Map that contains key-value pairs</p>\n</div></li><li><span class='pre'>file</span> : java.io.File<div class='sub-desc'><p>File</p>\n</div></li><li><span class='pre'>extension</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>contentString</span> : String<div class='sub-desc'><p>String to save</p>\n</div></li><li><span class='pre'>withoutBom</span> : String<div class='sub-desc'><p>Saves a string without BOM</p>\n</div></li><li><span class='pre'>contentObject</span> : Object<div class='sub-desc'><p>Object to save</p>\n</div></li><li><span class='pre'>outputStream</span> : java.io.OutputStream<div class='sub-desc'><p>Output stream to save</p>\n</div></li><li><span class='pre'>base64Content</span> : String<div class='sub-desc'><p>Base64 encoded content to save</p>\n</div></li><li><span class='pre'>tryUpdate</span> : Boolean<div class='sub-desc'><p>Inserts a new version if the object already exists</p>\n</div></li><li><span class='pre'>version</span> : String<div class='sub-desc'><p>Version</p>\n</div></li><li><span class='pre'>versionIncrement</span> : String|Number<div class='sub-desc'><p>Version increment, i.g. <code>1</code></p>\n</div></li><li><span class='pre'>versionComment</span> : String<div class='sub-desc'><p>Version comment</p>\n</div></li><li><span class='pre'>ownerId</span> : String<div class='sub-desc'><p>Owner Id for a new version if the object already exists</p>\n</div></li><li><span class='pre'>connection</span> : de.elo.ix.client.IXConnection<div class='sub-desc'><p>Index server connection</p>\n</div></li><li><span class='pre'>encryptionSet</span> : Number<div class='sub-desc'><p>Encryption set</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Object ID</p>\n</div></li></ul></div></div></div><div id='method-setSessionOption' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-setSessionOption' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-setSessionOption' class='name expandable'>setSessionOption</a>( <span class='pre'>sessionOption, value</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets a session option ...</div><div class='long'><p>Sets a session option</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sessionOption</span> : Number<div class='sub-desc'><p>Session option</p>\n</div></li><li><span class='pre'>value</span> : Boolean|String<div class='sub-desc'><p>Value</p>\n</div></li></ul></div></div></div><div id='method-setSessionOptions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-setSessionOptions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-setSessionOptions' class='name expandable'>setSessionOptions</a>( <span class='pre'>newOptions</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets session options ...</div><div class='long'><p>Sets session options</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>newOptions</span> : Object<div class='sub-desc'><p>Options, e.g. { SessionOptionsC.START_DOC_WORKFLOWS: true }</p>\n</div></li></ul></div></div></div><div id='method-sortSordsByObjIdArray' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-sortSordsByObjIdArray' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-sortSordsByObjIdArray' class='name expandable'>sortSordsByObjIdArray</a>( <span class='pre'>sords, objIds</span> ) : de.elo.ix.client.Sord[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Sorts an array of sords by another array of object IDs ...</div><div class='long'><p>Sorts an array of sords by another array of object IDs</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sords</span> : de.elo.ix.client.Sord[]<div class='sub-desc'><p>Sords</p>\n</div></li><li><span class='pre'>objIds</span> : Array<div class='sub-desc'><p>Object IDs</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord[]</span><div class='sub-desc'><p>Sords</p>\n</div></li></ul></div></div></div><div id='method-uploadSmallContent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-uploadSmallContent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-uploadSmallContent' class='name expandable'>uploadSmallContent</a>( <span class='pre'>objId, content, config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Uploads the content of a small repository document ...</div><div class='long'><p>Uploads the content of a small repository document</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID of the document.</p>\n</div></li><li><span class='pre'>content</span> : String<div class='sub-desc'><p>Content as string.</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>connection</span> : de.elo.ix.client.IXConnection<div class='sub-desc'><p>Index server connection</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-writeColors' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.RepoUtils'>sol.common.RepoUtils</span><br/><a href='source/lib_sol.common.RepoUtils.html#sol-common-RepoUtils-method-writeColors' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.RepoUtils-method-writeColors' class='name expandable'>writeColors</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Writes all colors ...</div><div class='long'><p>Writes all colors</p>\n</div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"singleton":true}});